////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/InputException.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link InputError} object is used to provide detailed information about an input related
 * issue during a flow execution.
 */
NS_REFINED_FOR_SWIFT
@interface InputError : NSObject


/** error code attached to the error (see OrchestrationErrorCodes.h) */
@property (nonatomic, readonly) int errorCode;

/** exception attached to the error */
@property (nonatomic, readonly, nullable) NSException *exception;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)new NS_UNAVAILABLE;
- (instancetype)initWithInputException:(InputException *)exception;

@end

NS_ASSUME_NONNULL_END
